<?php
header('Content-Type: text/plain');
include 'config.php';

$missing = [];

if (!isset($_POST['id']) || trim($_POST['id']) === '') {
    $missing[] = 'id';
}

if (!empty($missing)) {
    echo "All fields are required";
    exit;
}

$id = trim($_POST['id']);

$stmt = $conn->prepare("SELECT * FROM notice WHERE id = ? LIMIT 1");
$stmt->bind_param('s', $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    header('Content-Type: application/json');
    $data = $result->fetch_assoc();
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} else {
    echo "Not Found";
}
?>