<?php
header('Content-Type: text/plain');
include 'config.php';

$missing = [];

if (!isset($_POST['Auth']) || trim($_POST['Auth']) === '') {
    $missing[] = 'Auth';
}

if (!empty($missing)) {
    echo "All fields are required";
    exit;
}

$Auth = trim($_POST['Auth']);

$stmt = $conn->prepare("SELECT * FROM users WHERE Auth = ? LIMIT 1");
$stmt->bind_param('s', $Auth);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    header('Content-Type: application/json');
    $data = $result->fetch_assoc();
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} else {
    echo "User Not Found";
}
?>