<?php
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo "Access Denied";
    exit();
}

include 'config.php';

foreach(array('Progress', 'id', 'Auth', 'Amount') as $field) {
    if(!isset($_POST[$field]) || trim($_POST[$field]) == '') {
        echo $field." is required";
        exit();
    }
}

$sql = "UPDATE trx SET Progress = ? WHERE id = ?";
$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("ss", $_POST['Progress'], $_POST['id']);

    if ($stmt->execute()) {

        $check = $conn->prepare("SELECT Balance, Deposit FROM users WHERE Auth = ?");
        $check->bind_param("s", $_POST['Auth']);
        $check->execute();
        $result = $check->get_result();

        if ($result->num_rows > 0) {

            $data = $result->fetch_assoc();
            $newBalance = $data['Balance'] + $_POST['Amount'];
            $newDeposit = $data['Deposit'] + $_POST['Amount'];

            $update = $conn->prepare("UPDATE users SET Request='On', Balance=?, Deposit=? WHERE Auth=?");
            $update->bind_param("dds", $newBalance, $newDeposit, $_POST['Auth']);

            if ($update->execute()) {
                echo "Paid Successful";
            } else {
                echo "Paid Failed";
            }

            $update->close();

        } else {
            echo "Paid Failed";
        }

        $check->close();

    } else {
        echo "Paid Failed";
    }

    $stmt->close();

} else {
    echo "Paid Failed";
}

$conn->close();
?>